/*
 * Decompiled with CFR 0.152.
 */
package azmalent.terraincognita.common.world.biome;

import azmalent.cuneiform.lib.util.BiomeUtil;
import azmalent.terraincognita.common.registry.ModBiomes;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.fml.RegistryObject;

public abstract class BiomeEntry
implements Supplier<Biome> {
    public final RegistryObject<Biome> biome;
    public final ResourceLocation id;
    public final int spawnWeight;

    public BiomeEntry(String id, Supplier<Integer> spawnWeight) {
        this(id, spawnWeight.get());
    }

    public BiomeEntry(String id, int spawnWeight) {
        this.biome = ModBiomes.BIOMES.register(id, this::initBiome);
        this.id = this.biome.getId();
        this.spawnWeight = spawnWeight;
        ModBiomes.ID_TO_BIOME_MAP.put(this.id, this);
    }

    @Override
    public Biome get() {
        return (Biome)this.biome.get();
    }

    public int getNumericId() {
        return WorldGenRegistries.field_243657_i.func_148757_b((Object)this.biome.get());
    }

    protected final Biome initBiome() {
        Biome.Climate climate = this.getClimate();
        BiomeAmbience ambience = this.getAmbience();
        BiomeGenerationSettings settings = new BiomeGenerationSettings.Builder().func_242519_a(this::getSurfaceBuilder).func_242508_a();
        MobSpawnInfo spawns = this.initSpawns().func_242577_b();
        return new Biome.Builder().func_205419_a(this.getCategory()).func_205421_a(this.getDepth()).func_205420_b(this.getScale()).func_205414_c(climate.field_242461_c).func_242456_a(climate.field_242462_d).func_205415_a(climate.field_242460_b).func_205417_d(climate.field_242463_e).func_235097_a_(ambience).func_242458_a(spawns).func_242457_a(settings).func_242455_a();
    }

    public void register() {
        RegistryKey key = BiomeUtil.getBiomeKey((ResourceLocation)this.id);
        BiomeDictionary.addTypes((RegistryKey)key, (BiomeDictionary.Type[])this.getBiomeDictionaryTypes().toArray(new BiomeDictionary.Type[0]));
    }

    protected abstract Biome.Category getCategory();

    protected abstract Biome.Climate getClimate();

    protected abstract float getDepth();

    protected abstract float getScale();

    protected abstract BiomeAmbience getAmbience();

    protected abstract ConfiguredSurfaceBuilder<?> getSurfaceBuilder();

    protected abstract MobSpawnInfo.Builder initSpawns();

    protected abstract BiomeManager.BiomeType getBiomeType();

    protected abstract List<BiomeDictionary.Type> getBiomeDictionaryTypes();

    public abstract void initFeatures(BiomeGenerationSettingsBuilder var1);

    protected void initDefaultFeatures(BiomeGenerationSettings.Builder builder) {
        DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243742_f((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243746_h((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243748_i((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243750_j((BiomeGenerationSettings.Builder)builder);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean hasCustomGrassModifier() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getCustomGrassColor(double x, double z) {
        throw new AssertionError((Object)("Custom grass color is not defined for biome " + this.biome.getId()));
    }

    protected static int getSkyColorWithTemperatureModifier(float temperature) {
        float lvt_1_1_ = temperature / 3.0f;
        lvt_1_1_ = MathHelper.func_76131_a((float)lvt_1_1_, (float)-1.0f, (float)1.0f);
        return MathHelper.func_181758_c((float)(0.62222224f - lvt_1_1_ * 0.05f), (float)(0.5f + lvt_1_1_ * 0.1f), (float)1.0f);
    }
}

